<?php
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit();
}

/**
 * Cleanup data added by this plugin on uninstall.
 */
function astoundify_wpjmlp_cleanup_on_uninstall () {
	global $wpdb;

	// Settings.
	delete_option( 'wpjmlp_db_version' );
	// this key is created by the plugin updater.
	delete_option( 'wp-job-manager-listing-payments_status' );

	// drop db tables created
	$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}wcpl_user_packages" ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared

//	// Avoid removing meta-data that is not added by this plugin.
//	// Commented because Claim Listings should clear `_user_package_id` if it's removed.
//	$listings = get_posts(
//		array(
//			'post_type'   => 'job_listing',
//			'post_status' => 'any',
//			'numberposts' => -1,
//			'fields'      => 'ids',
//		)
//	);
//	if ( ! empty( $listings ) ) {
//		foreach ( $listings as $listing ) {
//			delete_post_meta( $listing, '_user_package_id' );
//		}
//	}

}

if ( ! is_multisite() ) {
	// Only do deletion if the setting is true.
	$do_deletion = get_option( 'job_manager_delete_data_on_uninstall' );
	if ( $do_deletion ) {
		astoundify_wpjmlp_cleanup_on_uninstall();
	}
} else {
	global $wpdb;

	$blog_ids         = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );
	$original_blog_id = get_current_blog_id();

	foreach ( $blog_ids as $blog_id ) {
		switch_to_blog( $blog_id );

		// Only do deletion if the setting is true.
		$do_deletion = get_option( 'job_manager_delete_data_on_uninstall' );
		if ( $do_deletion ) {
			astoundify_wpjmlp_cleanup_on_uninstall();
		}
	}

	switch_to_blog( $original_blog_id );
}
